﻿using Microsoft.SharePoint;
using Microsoft.SharePoint.Administration;
using System;

namespace Code6587EN.Ch04
{
    public class BrandingTimerJob : SPJobDefinition
    {
        private static Guid BrandingFeatureId = new Guid("1150dec7-4af6-44d8-b241-d976d26b723c");

        public BrandingTimerJob(SPWebApplication webApplication, string title) :
            base("Custom Branding Job", webApplication, null, SPJobLockType.ContentDatabase)
        {
            this.Title = title;
        }

        public BrandingTimerJob() : base() { }

        public override void Execute(Guid targetInstanceId)
        {
            Guid? siteId = null;

            // Get the Site Collection Id associated with the timer job
            if (this.Properties.ContainsKey("SiteId"))
                siteId = this.Properties["SiteId"] as Guid?;

            // Ensure the Site Collection Id is not null
            if (siteId != null)
            {
                // Open the Site Collection
                using (var site = new SPSite(siteId.Value))
                {
                    // Ensure the Site Collection is not null
                    if (site != null)
                    {
                        // Iterate through each Site in the Site Collection
                        foreach (SPWeb web in site.AllWebs)
                        {
                            // Check to ensure the Site is not null and it exists
                            if (web != null && web.Exists)
                            {
                                // If the feature is not activated on the Site, activate it
                                if (web.Features[BrandingFeatureId] == null)
                                    web.Features.Add(BrandingFeatureId);
                            }
                        }
                    }
                }
            }
        }
    }
}
